#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Equithirds tilingMod01.fsh   by   jeyko
//https://www.shadertoy.com/view/WtSczR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// This is a no-math, all number crunched, Equithirds tiling:
// https://tilings.math.uni-bielefeld.de/substitution/equithirds/


#define rot(j) mat2(cos(j),-sin(j),sin(j),cos(j))
#define pi acos(-1.)
#define tau (2.*pi)

float sdTriangleIsosceles( in vec2 p, in vec2 q )
{
    p.x = abs(p.x);
    vec2 a = p - q*clamp( dot(p,q)/dot(q,q), 0.0, 1.0 );
    vec2 b = p - q*vec2( clamp( p.x/q.x, 0.0, 1.0 ), 1.0 );
    float s = -sign( q.y );
    vec2 d = min( vec2( dot(a,a), s*(p.x*q.y-p.y*q.x) ),
                  vec2( dot(b,b), s*(p.y-q.y)  ));
    return -sqrt(d.x)*sign(d.y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord - 0.5*iResolution.xy)/iResolution.y;

    
    vec3 col = vec3(0);
    
    float iters = 9.;
    
    float d = 10e5;
    
    // mafs
    vec2 s = vec2(0.173,0.1);

    
    uv.y -= s.y*0.35;

    uv += vec2(sin(iTime),cos(iTime))*0.1;    
    uv *= 0.06;

    
    float id = 0.;
    vec2 p = uv;
    float sc = 1.;
    
    float id0cnt = 0.;
    float id1cnt = 0.;
    float palcnt = 0.;
    
    for(float i = 0.; i < iters; i++){
        
        if( id == 0. ){
        
        	mat2 rb = rot(tau/3.*1.);
        	mat2 rc = rot(tau/3.*2.); 
        
            float szsc = 1.*sc;
            
            float da = sdTriangleIsosceles( p   , s*szsc);
            float db = sdTriangleIsosceles( p*rb, s*szsc);
            float dc = sdTriangleIsosceles( p*rc, s*szsc);

            if( da < 0. ){
                palcnt++;
            } else if( db < 0. ){
				p *= rb;
                palcnt += 1.5;
            } else if( dc < 0. ){
                palcnt += 2.5;
				p *= rc;
            } 
            p.y -= 0.5*s.y*szsc;
            
            d = min(d,abs(da));
            d = min(d,abs(db));
            d = min(d,abs(dc));
            id = 1.;
            
            id0cnt ++;
        
        } else if (id == 1.) {
            float ramt = tau/5.*2.0835;
            mat2 ra = rot(-ramt);
            mat2 rb = rot(ramt);
            
            vec2 transa = vec2(-0.075,0.0144);
            vec2 transb = vec2(-transa.x,transa.y);
            
            float szsc = sc*0.579;
            
            vec2 pa = (p*ra + transa*sc );
            vec2 pb = (p*rb + transb*sc );
            
            
            float da = sdTriangleIsosceles( pa, s*szsc);
            float db = sdTriangleIsosceles( pb, s*szsc);
            
            
            if(da < 0.){
                p = p*ra + transa*sc*vec2(1.,-1.);
                sc = szsc;
                id = 1.;
                palcnt += 1.5;
            } else if(db < 0.){
                p = p*rb + transb*sc*vec2(1.,-1.);
                col += 0.03;
                sc = szsc;
                id = 1.;
                palcnt += 1.;
            } else {
                p.y -= s.y*szsc/3.5;
                
                sc *= 0.335;
                id = 0.;
                palcnt += .5;
            }
            
            
            id1cnt++;
        	d = min(d,abs(da));
        	d = min(d,abs(db));
        }
    }
    
    
    #define pal(a,b,c,d,e) (a + b*sin(c*d + e))
    
    col = mix(col,pal(0.5,0.5,vec3(2.,0.7,0.2),1., id1cnt*7. +  id0cnt*5. + palcnt*7. + 4. + iTime/2. + uv.x*1. )/1.,smoothstep(dFdx(uv.x),0.,-d));
    
    d = abs(d);
    
    float w = 0.00006;
    
    col = mix(col,vec3(0.01),smoothstep(dFdx(uv.x) + w,w,d));
    
    
    col = pow(col,vec3(0.454545));
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

